oauth_explorer_proxy_url = '';

function getConsumerInfo() {
	var base_url = $('#base-url').val();
	
	var consumer = {
		consumerKey   				: $('#consumer-key').val(),
		consumerSecret				: $('#consumer-secret').val(),
		serviceProvider: {
			signatureMethod			: $('#signature-method').val(),
			requestTokenURL			: base_url + '/' + $('#request-token-url').val(), 
			userAuthorizationURL	: base_url + '/' + $('#authorize-url').val(),
			accessTokenURL			: base_url + '/' + $('#access-token-url').val()
		}
	};

	return consumer;
}

$( function() {
	$('form').submit( function() { return false; });
	
	$('#get-request-token').click(function(e) {
		var consumer = getConsumerInfo();
		
		var accessor = { consumerSecret: consumer.consumerSecret,
						 consumerKey: consumer.consumerKey };
	    var message = { action: consumer.serviceProvider.requestTokenURL,
						method: 'GET',
						parameters: []};
	    
		doOAuthCall( message, accessor, function( data, textStatus ) {
			$('#call-content').val( data );
			var list   = OAuth.getParameterMap( OAuth.decodeForm( data ) );
			$('#request-key').val( list.oauth_token );
			
			$('#request-secret').val( list.oauth_token_secret );
			$('#request-token').show();
		});
	});
	
	$('#get-authentication').click( function() {
		var consumer = getConsumerInfo();
		var token = $('#request-key').val();
		var url = consumer.serviceProvider.userAuthorizationURL + '?oauth_token=' + OAuth.percentEncode(token);
		window.open( url );
	});
	
	$('#get-access-token').click(function(e) {
		var consumer = getConsumerInfo();
		
		var accessor = { consumerSecret: consumer.consumerSecret,
						 consumerKey: consumer.consumerKey,
						 token: $('#request-key').val(),
						 tokenSecret: $('#request-secret').val() };
						
	    var message = { action: consumer.serviceProvider.accessTokenURL,
						method: 'GET',
						parameters: []
	                  };
	    
		doOAuthCall( message, accessor, function( data, textStatus ) {
			$('#call-content').val( data );
			var list   = OAuth.getParameterMap( OAuth.decodeForm( data ) );
			$('#access-key').val( list.oauth_token );
			$('#access-secret').val( list.oauth_token_secret );
			
			$('#access-token').show();
			$('#request-token').hide();
		});
	});
	
	$('#custom-call-form').submit( function() {
		if( $('#access-key').val() != '' && $('#call-url').val() != '' ) {
			
			var consumer = getConsumerInfo();

			var accessor = { consumerSecret: consumer.consumerSecret,
							 consumerKey: consumer.consumerKey,
							 token: $('#access-key').val(),
							 tokenSecret: $('#access-secret').val() };

		    var message = { action: $('#call-url').val(),
							method: 'GET',
							parameters: [] };

			doOAuthCall( message, accessor, function( data, textStatus ) {
				$('#call-content').val( data );
			});
		}
	});
});

function doOAuthCall( message, accessor, oncmp ) {
	OAuth.completeRequest(message, accessor);

	var bs = OAuth.SignatureMethod.getBaseString( message );
	var ah = OAuth.getAuthorizationHeader('OAuth', message.parameters );		
	var cg = OAuth.addToURL( message.action, message.parameters );

	$('#signature-base-string').val(bs);
	$('#auth-header').val(ah);
	$('#combined-get').val(cg);
	$('#call-content').val('Call in progress..');
	
	if( oauth_explorer_proxy_url == '' ) {
		jQuery.ajaxSetup({
			'beforeSend': function(xhr) {
				xhr.setRequestHeader("Authorization", ah)
			}
		});
		jQuery.get( message.action, [], oncmp, 'text');
	} else {
		jQuery.ajaxSetup({
			'beforeSend': function(xhr) {
				xhr.setRequestHeader("X-Forward-Url", message.action);
				xhr.setRequestHeader("Authorization", ah);
			}
		});
		jQuery.get( oauth_explorer_proxy_url, [], oncmp, 'text');
	}
}